# Sonic Adventure DX

## What does randomization do to this game?

The randomizer shuffles emblems, upgrades, playable characters, and some key items into the AP item pool.
The story itself is not present, but you still use the adventure fields to navigate between stages and other locations.
The goal is to beat Perfect Chaos, which is locked behind different requirements depending on the settings.
Those requirements can be emblems, chaos emeralds, stage completion, mission completion, or a combination of those.

## What items and locations get randomized?

### The possible location checks include the following:

- Action Stages (all 3 missions).
- Upgrades.
- Adventure Fields Emblems.
- Sublevels (Twinkle Circuit, Sand Hill & Sky Chase 1/2).
- Bosses.
- Missions.
- Life capsules.

Most locations can be disabled in the settings.

### The items that are randomized are:

- Emblems.
- Chaos Emeralds.
- Upgrades.
- Playable characters.
- Key items.
- Filler items and traps.

You can decide which characters are available to play as, and you will start with one of them unlocked.

## What other changes are made to the game?

### Boss fights

To enter the boss fights, sky chase, and the past (to get Tails' Rhythm Badge), the mod adds a number of warp platforms.
These warp platforms are located in the Adventure Fields and exist near the boss fight location in the story.

### Key items

To add some progression to the game, the mod adds key items that are required to progress.
These key items include the in-game travel methods, keys, and other items that are required to progress.
Examples include the `Train`, `Hotel Keys`, and `Ice Stone`.

## Is there any guide for those locations and items?

Yes, a wiki with screenshots can be
found [here](https://github.com/ClassicSpeed/SADX-Archipelago-Locations-Wiki/blob/main/README.md).

## What does another world's item look like in Sonic Adventure DX?

Most of the item checks look like the original game with 2 exceptions:

- The adventure field emblems are replaced with an archipelago model.
- Life capsules' images are replaced with an archipelago sprite.

## When the player receives an emblem or item, what happens?

When the player checks a location, a text will appear in the top left corner of the screen with the item's information.
The text will also show when the player receives an item from another player.

## How can I get started?

To install the mod and start playing, follow
the [setup guide](https://github.com/ClassicSpeed/Archipelago/blob/sadx_initial_version/worlds/sadx/docs/setup_en.md).